
if not hud then hud = {} end
if not hud.tips then hud.tips = {} end
if not hud.active_tips then hud.active_tips = {} end
if not hud.tool_tips then hud.tool_tips = {} end
if not hud.vehicle_tips then hud.vehicle_tips = {} end

hud.restart_tip_ps_id = -1
-- How many meters above the pioneer that the HUD PS should appear
hud.vertical_ps_offset = 4

function hud.update()
	if c2d_settings.enable_zone_tips then hud.update_zone_tips() end	
	hud.update_tool_arrow_tips()
	hud.update_vehicle_arrow_tips()
	hud.update_restart_tip()
end

function hud.add_zone_tip(zone, ps_name)
	if not hud.tips[zone] then
		hud.tips[zone] = {} 
		hud.active_tips[zone] = {}
	end
	hud.tips[zone] = ps_name
end

function hud.update_zone_tips()
	
	-- go throught all controllers and add tip if needed
	for i=scene:GetControllersCount()-1, 0, -1 do
		local ctrl = scene:GetController(i)
		local asm = ctrl:GetAssemblyLinked()
		if asm and not asm:IsDead() and ctrl:GetIsPlayerOrRemoteControlled() then 
			local pos = asm:GetApproxPos()
			for i, zone in ipairs(scene:GetZoneNamesAtPoint(pos)) do
				if zone ~= "" then
					-- add tip in this zone for this controlled if not added yet
					if hud.tips[zone] then
						local ps_name = hud.tips[zone]
						
						if not hud.active_tips[zone][ctrl:GetID()] then
							-- add tip ps
							hud.active_tips[zone][ctrl:GetID()] = {}
							local atip = hud.active_tips[zone][ctrl:GetID()]
							local ps = scene:AddPS(hud.tips[zone], pos)
							if ps then
								atip.ps_id = ps:GetID()
							end
						end
					end
					
				end
			end
		end
	end
	
	-- go through all active tips, update position and delete if inactive
	for zone, tips in pairs(hud.active_tips) do
		
		local remlist = {}
		
		for ctrl_id, tip in pairs(tips) do
			local ctrl = scene:GetControllerByID(ctrl_id)
			if ctrl then
				local asm = ctrl:GetAssemblyLinked()
				if asm then
					local ps = scene:GetPSByID(tip.ps_id)
					if ps then
						
						--pin fading out ps to target after pickup/entering
						ps:SetParticleEmitting(false)
						if tip.tool_target and scene:GetAssemblyByID(tip.tool_target) then
							local pos = scene:GetAssemblyByID(tip.tool_target):GetApproxPos()
							ps:SetPosition(pos + scene:RotateVectorForGravityPrecise(VectorF(0,hud.vertical_ps_offset), pos))
						elseif tip.joint_target and scene:GetJointByID(tip.joint_target) then
							local pos = scene:GetJointByID(tip.joint_target):GetWorldPositionA()
							ps:SetPosition(pos + scene:RotateVectorForGravityPrecise(VectorF(0,hud.vertical_ps_offset), pos))
						end
						
						if zone == "Pickup Tip" then
							--hover over gun
							local tools = scene:GetAllToolsForArrowTip(10)
							for i,tool in pairs(tools) do
								local tool_pos = tool:GetApproxPos()
								if scene:IsInsideZone(tool_pos, zone) then
									local asm_pos = asm:GetApproxPos()
									ps:SetParticleEmitting(scene:IsInsideZone(asm_pos, zone) and not asm:IsDead())
									ps:SetPosition(tool_pos + scene:RotateVectorForGravityPrecise(VectorF(0,hud.vertical_ps_offset), tool_pos))
									tip.tool_target = tool:GetID()
									break
								end
							end
						elseif zone == "Mount Vehicle Tip" then
							--hover over vehicle
							local joints = scene:GetAllJointsForArrowTip(10)
							for i,joint in pairs(joints) do
								local joint_pos = joint:GetWorldPositionA()
								if scene:IsInsideZone(joint_pos, zone) then
									local asm_pos = asm:GetApproxPos()
									ps:SetParticleEmitting(scene:IsInsideZone(asm_pos, zone) and not asm:IsDead())
									ps:SetPosition(joint_pos + scene:RotateVectorForGravityPrecise(VectorF(0,hud.vertical_ps_offset),joint_pos))
									tip.joint_target = joint:GetID()
									break
								end
							end
						elseif zone == "Unmount Vehicle Tip" then
							--hover over player, only if in vehicle
							if asm:IsMountedToAnything() then
								local asm_pos = asm:GetApproxPos()
								ps:SetParticleEmitting(scene:IsInsideZone(asm_pos, zone) and not asm:IsDead())
								ps:SetPosition(asm_pos + scene:RotateVectorForGravityPrecise(VectorF(0,hud.vertical_ps_offset),asm_pos))
							end
						else
							--hover over player
							local asm_pos = asm:GetApproxPos()
							ps:SetParticleEmitting(scene:IsInsideZone(asm_pos, zone) and not asm:IsDead())
							ps:SetPosition(asm_pos + scene:RotateVectorForGravityPrecise(VectorF(0,hud.vertical_ps_offset),asm_pos))
						end
						
						else
						table.insert( remlist, {["zone"]=zone, ["id"]=ctrl_id} )
					end
				else
					table.insert( remlist, {["zone"]=zone, ["id"]=ctrl_id} )
				end
			else
					table.insert( remlist, {["zone"]=zone, ["id"]=ctrl_id} )
			end
		end

		-- delete inactive tips
	  for k, v in pairs( remlist ) do
			local tip = hud.active_tips[v.zone][v.id]
			local ps = scene:GetPSByID(tip.ps_id)
			if ps then
				ps:SetParticleEmitting(false)
			end	
			hud.active_tips[v.zone][v.id]=nil
		end
		
	end
end

function hud.update_tool_arrow_tips()
	
	for i, tool in pairs(hud.tool_tips) do
		tool.del = true
	end
	
	local tools = scene:GetAllToolsForArrowTip(10)
	for i,tool in pairs(tools) do
		local tool_id = tool:GetID()
		local pos = tool:GetApproxPos()
		if hud.tool_tips[tool_id] then
		-- update tool tip
			hud.tool_tips[tool_id].del = false
			
		else
		-- add tool tip
			local ps = scene:AddPS("Tip Tool Arrow", pos)
			if ps then
				ps:EmitBoom()
				
				hud.tool_tips[tool_id] = {}
				local tip = hud.tool_tips[tool_id]
				tip.ps_id = ps:GetID()
				tool.del = false
			end
		end
	end
	
	local remlist = {}
	for i, tool in pairs(hud.tool_tips) do
		if tool.del then
			remlist[i] = i
		else
			local tool_ass = scene:GetAssemblyByID(i)
			if tool_ass then
				local ps = scene:GetPSByID(tool.ps_id)
				if ps then
					local pos = tool_ass:GetApproxPos()
					if tool_ass:GetMasterMO() then pos = tool_ass:GetMasterMO():GetPosition() end
					ps:SetPosition(pos + scene:RotateVectorForGravity(VectorF(0,1.0), pos))
					scene:WriteToScreenByWorldPos(string.without_first_word(tool_ass:GetName()),
						pos + scene:RotateVectorForGravity(VectorF(0,1.0), pos), VectorF(0,12), Yes, ColorRGBA(0,255,255,200), ColorRGBA(0,60,255,100))
				else
					remlist[i] = i
				end
			else
				remlist[i] = i
			end
		end
	end

	for k, v in pairs( remlist ) do
		local ps = scene:GetPSByID(hud.tool_tips[k].ps_id)
		if ps then
			ps:SetParticleEmitting(false)
			ps:DeleteAllParticles()
		end
		hud.tool_tips[k]=nil
	end
end





function hud.update_vehicle_arrow_tips()
	
	for i, vehicle in pairs(hud.vehicle_tips) do
		vehicle.del = true
	end
	
	local joints = scene:GetAllJointsForArrowTip(10)
	for i,joint in pairs(joints) do
		local joint_id = joint:GetID()
		local pos = joint:GetWorldPositionA()
		if hud.vehicle_tips[joint_id] then
		-- update vehicle tip
			hud.vehicle_tips[joint_id].del = false
			
			--check if ctrl is entering this joint
			local entering_ps_name = "Tip Vehicle Arrow Entering"
			local vehicle_id = joint:GetAssemblyLinked():GetID()
			
			-- find any assembly entering this vehicle
			local asm_entering = nil
			for i=scene:GetControllersCount()-1, 0, -1 do
				local ctrl = scene:GetController(i)
				local asm = ctrl:GetAssemblyLinked()
				if asm then
					asm = GetAssemblyLuaObj(asm)
					if asm.entering_vehicle_aid == vehicle_id then
						asm_entering = ctrl:GetAssemblyLinked()
						break
					end
				end
			end
			
			
			if asm_entering then
				asm = GetAssemblyLuaObj(asm_entering)
				local ps = scene:GetPSByID(hud.vehicle_tips[joint_id].ps_id)
				if not ps or ps:GetName() ~= entering_ps_name then
					--remove ps
					if ps then
						ps:DeleteAllParticles()
					end
					--add new ps
					local ps = scene:AddPS(entering_ps_name, pos)
					if ps then
						ps:EmitBoom()
						
						local tip = hud.vehicle_tips[joint_id]
						tip.ps_id = ps:GetID()
						joint.del = false
					end
				end
			else
				--ctrl not entering anymore
				local ps = scene:GetPSByID(hud.vehicle_tips[joint_id].ps_id)
				if not ps or ps:GetName() == entering_ps_name then
					hud.vehicle_tips[joint_id].del = true
				end
			end
		
		else
		-- add vehicle tip
			local ps = scene:AddPS("Tip Vehicle Arrow", pos)
			if ps then
				ps:EmitBoom()
				
				hud.vehicle_tips[joint_id] = {}
				local tip = hud.vehicle_tips[joint_id]
				tip.ps_id = ps:GetID()
				joint.del = false
			end
		end
	end
	
	local remlist = {}
	for i, tip in pairs(hud.vehicle_tips) do
		if tip.del then
			remlist[i] = i
		else
			local joint = scene:GetJointByID(i)
			if joint then
				local ps = scene:GetPSByID(tip.ps_id)
				if ps then
					local pos = joint:GetWorldPositionA()
					ps:SetPosition(pos + scene:RotateVectorForGravity(VectorF(0,1.0), pos))
					if joint:GetAssemblyLinked() then
						scene:WriteToScreenByWorldPos(joint:GetAssemblyLinked():GetName(),
							pos + scene:RotateVectorForGravity(VectorF(0,1.0), pos), VectorF(0,12), Yes, ColorRGBA(0,255,255,200), ColorRGBA(0,60,255,100) )
					end
				else
					remlist[i] = i
				end
			else
				remlist[i] = i
			end
		end
	end

	for k, v in pairs( remlist ) do
		local ps = scene:GetPSByID(hud.vehicle_tips[k].ps_id)
		if ps then
			ps:SetParticleEmitting(false)
			ps:DeleteAllParticles()
		end
		hud.vehicle_tips[k]=nil
	end
end



function hud.update_restart_tip()
	if hud.restart_tip_ps_id == -1 then
		if scene:GetAllHumanControllersAreDead() and scene:GetName() ~= "Asteroid Belt X79Q" then
			local ps = scene:AddPS("HUD Middle Right HOLD", VectorF(0,0))
			if ps then
				hud.restart_tip_ps_id = ps:GetID()
				ps:EmitBoom()
			end
		end
	else
		if not scene:GetAllHumanControllersAreDead() then
			scene:DeletePS(scene:GetPSByID( hud.restart_tip_ps_id ))
			hud.restart_tip_ps_id = -1
		end
	end
end






























